﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Business.Db" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Deklaracja ZUS Z-3b</title>
		<script runat="server">

    string NBSP(string ss) {
		return ss=="" ? "&nbsp;" : ss;
    }

    void LiczDaneFirmy(PracHistoria ph) {
        CoreModule core = CoreModule.GetInstance(dc);
        string nip = core.Config.Firma.Pieczątka.NIP;
        string regon = core.Config.Firma.Pieczątka.REGON;
        string nazwask = core.Config.Firma.Pieczątka.NazwaSkrócona;
        string nazwisko = core.Config.Firma.DaneEwidencyjne.Nazwisko;
        string imie = core.Config.Firma.DaneEwidencyjne.Imię;
        string kodp = core.Config.Firma.AdresSiedziby.KodPocztowyS;
        string poczta = core.Config.Firma.AdresSiedziby.Poczta;
        string gmina = core.Config.Firma.AdresSiedziby.Gmina;
        string miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
        string ulica = core.Config.Firma.AdresSiedziby.Ulica;
        string dom = core.Config.Firma.AdresSiedziby.NrDomu;
        string lokal = core.Config.Firma.AdresSiedziby.NrLokalu;
        string tel = core.Config.Firma.AdresSiedziby.Telefon;
        string symbol = core.Config.Firma.AdresSiedziby.KodKraju;
        string kodz = core.Config.Firma.AdresSiedziby.ZagranicznyKodPocztowy;
        string panstwo = core.Config.Firma.AdresSiedziby.Kraj;
        if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
            OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
            if (!string.IsNullOrEmpty(of.Deklaracje.NIP)) nip = of.Deklaracje.NIP;
            if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
            if (!string.IsNullOrEmpty(of.NazwaSkrocona)) nazwask = of.NazwaSkrocona;
            if (!string.IsNullOrEmpty(of.Adres.KodPocztowyS)) kodp = of.Adres.KodPocztowyS;
            if (!string.IsNullOrEmpty(of.Adres.Poczta)) poczta = of.Adres.Poczta;
            if (!string.IsNullOrEmpty(of.Adres.Gmina)) gmina = of.Adres.Gmina;
            if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
            if (!string.IsNullOrEmpty(of.Adres.Ulica)) ulica = of.Adres.Ulica;
            if (!string.IsNullOrEmpty(of.Adres.NrDomu)) dom = of.Adres.NrDomu;
            if (!string.IsNullOrEmpty(of.Adres.NrLokalu)) lokal = of.Adres.NrLokalu;
            if (!string.IsNullOrEmpty(of.Adres.Telefon)) tel = of.Adres.Telefon;
            if (!string.IsNullOrEmpty(of.Adres.KodKraju)) symbol = of.Adres.KodKraju;
            if (!string.IsNullOrEmpty(of.Adres.ZagranicznyKodPocztowy)) kodz = of.Adres.ZagranicznyKodPocztowy;
            if (!string.IsNullOrEmpty(of.Adres.Kraj)) panstwo = of.Adres.Kraj;
        }
        
        NIP.EditValue = NBSP(nip.Replace("-", ""));
		REGON.EditValue = NBSP("");
		PESEL.EditValue = NBSP("");
        RODZAJ.EditValue = NBSP("");
		DOKUMENT.EditValue = NBSP("");
        NAZWASK.EditValue = NBSP(nazwask);
        NAZWISKO.EditValue = NBSP(nazwisko);
        IMIE.EditValue = NBSP(imie);
        KODP.EditValue = NBSP(kodp);
        POCZTA.EditValue = NBSP(poczta);
        GMINA.EditValue = NBSP(gmina);
        MIEJSCOWOSC.EditValue = NBSP(miejscowosc);
        ULICA.EditValue = NBSP(ulica);
        DOM.EditValue = NBSP(dom);
        LOKAL.EditValue = NBSP(lokal);
        TEL.EditValue = NBSP(tel);
        SYMBOL.EditValue = NBSP(symbol);
        KODZ.EditValue = NBSP(kodz);
        PANSTWO.EditValue = NBSP(panstwo);
        MAIL.EditValue = NBSP("");
        
		if (regon!="")
			REGON.EditValue = NBSP(regon);
		if (nip=="" || regon=="")
            if (core.Config.Firma.DaneEwidencyjne.OsobaFizyczna) {
				string pesel = core.Config.Firma.DaneEwidencyjne.PESEL;
				if (pesel=="") {
					Wlasciciel wls = DeklaracjeModule.GetInstance(dc).Config.ZUS.Ogólne.DaneWłaściciela;
					if (wls!=null) {
						pesel = NBSP(wls.Last.PESEL);
						if (pesel=="") {
                            RODZAJ.EditValue = NBSP(wls.Last.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty ? "1" : "2");
							DOKUMENT.EditValue = NBSP(wls.Last.Dokument.SeriaNumer);
                        }
					}
				}
				if (pesel!="")
					PESEL.EditValue = NBSP(pesel);
			}
	}

    string Przekreśl(string tekst) {
        string przekreślOn = "<font style=\"text-decoration: line-through\">";
        string przekreślOff = "</font>";
        return przekreślOn + tekst + przekreślOff;
    }
    
    void LiczDanePracownika(PracHistoria ph) {
        bool dowod = ph.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
        if (ph.NIP == "" || ph.PESEL == "") {
            DOKRODZAJ.EditValue = dowod ? "1" : "2";
            DOKUBEZP.EditValue = ph.Dokument.SeriaNumer;
        }
        else {
            DOKRODZAJ.EditValue = NBSP("");
            DOKUBEZP.EditValue = NBSP("");
        }
        Date ur = ph.Urodzony.Data;
        if (ur != Date.Empty)
            URODZONY.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
        IAdres adres = !ph.AdresZamieszkania.IsEmpty() ? ph.AdresZamieszkania : ph.AdresZameldowania;
        AdresKodPocztowyS.EditValue = adres.KodPocztowyS;
        AdresPoczta.EditValue = adres.Poczta;
        AdresGmina.EditValue = adres.Gmina;
        AdresMiejscowosc.EditValue = adres.Miejscowosc;
        AdresUlica.EditValue = adres.Ulica;
        AdresNrDomu.EditValue = adres.NrDomu;
        AdresNrLokalu.EditValue = adres.NrLokalu;
        AdresKodKraju.EditValue = adres.KodKraju;
        AdresZagranicznyKodPocztowy.EditValue = adres.ZagranicznyKodPocztowy;
        AdresKraj.EditValue = adres.Kraj;
        if (ph.Pracownik.DomyslnyRachunek != null)
            RachunekBank.EditValue = ph.Pracownik.DomyslnyRachunek;
        else
            RachunekBank.EditValue = "&nbsp;";
        string strTak = "tak/" + Przekreśl("nie");
        string strNie = Przekreśl("tak") + "/nie";
        UbezpChor.EditValue = ph.Etat.Ubezpieczenia.Chorobowe.Dobrowolne ? strTak : strNie;
        UbezpWyp.EditValue = ph.Etat.Ubezpieczenia.Wypadkowe.Obowiazkowe ? strTak : strNie;
    }
		
    string StripHTML(string HTMLText) {
        var reg = new Regex("<[^>]+>", RegexOptions.IgnoreCase);
        return reg.Replace(HTMLText, "");
    }

    void SetHeader() {
        IPieczątkaFirmy pf = ReportHeader.GetPieczątka(dc);
        dlFirma.EditValue = string.Format("<strong>{0}</strong>", pf.NazwaFormatowana);
        dlAdres1.EditValue = pf.Adres.Linia1;
        dlAdres2.EditValue = pf.Adres.Linia2;
        dlNIP.EditValue = string.Format("NIP: {0}", pf.NIP);
        BusinessModule bm = BusinessModule.GetInstance(dc.Session);
        ReportsLeaf rf = bm.Config.Reports.Defaults;
        string strip = StripHTML(rf.Postscript);
        dlDodatkowe.EditValue = "<font size='1pt'>" + strip + "</font><br/>";
        dlDodatkowe.Visible = !string.IsNullOrEmpty(strip);
    }

    void OnContextLoad(Object sender, EventArgs args) {
           SetHeader();
           dc.LeftMargin = dc.TopMargin = dc.RightMargin = dc.BottomMargin = 19;
           PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
           Pracownik pracownik = ph.Pracownik;

           LiczDaneFirmy(ph);
           LiczDanePracownika(ph);
    }
	        
       public static void Msg(object obj) {
       }

</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body style="font-family: Tahoma">
		<form id="DeklaracjaZ3" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.KadryPlace"></ea:datacontext>
            <ea:Section ID="Section1" runat="server" SectionType="Header"></ea:Section>
            <p align="right">
                <b>ZUS Z-3b</b>
            </p>
            <table cellSpacing="0" width="100%" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; font-family: tahoma; text-align:left;">
			    <tr>
            		<td width="35%" valign="top" align="left" style="border-width: 0px 0px 0px 0px; border-style: solid; border-color: silver; font-size: 9pt;">
				        <ea:datalabel id="dlFirma" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlAdres1" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlAdres2" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlNIP" runat="server" Bold="false"></ea:datalabel><br /> 
				        <ea:datalabel id="dlDodatkowe" runat="server" Bold="false"></ea:datalabel>
                        ......................................................<br />
                        &nbsp;&nbsp;&nbsp;&nbsp;Pieczątka płatnika składek [1]<br /> 
                    </td>
                </tr>
            </table>
            <br />
            <p align="center">
                <b>ZAŚWIADCZENIE PŁATNIKA SKŁADEK</b><br />
                <ea:datalabel id="dlTitle" runat="server" Bold="false"></ea:datalabel><br />
                <b>Przed wypełnieniem należy zapoznać się z pouczeniem</b><br />
                (wypełnia płatnik składek)<br />
            </p>
			<P>
                <b>DANE IDENTYFIKACYJNE PŁATNIKA SKŁADEK</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">01. Numer NIP (wpisać bez kresek)</FONT><FONT size="1"><span style="vertical-align: super">
                                (1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">02. Numer REGON</FONT><FONT size="1"><span style="vertical-align: super">
                                (1)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="NIP" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="REGON" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD valign="bottom"><FONT size="2">03. Numer PESEL</FONT></TD>
						<TD></TD>
						<TD><FONT size="2">04. Rodzaj dokumentu tożsamości: jeśli dowód osobisty, wpisać 1, jeśli inny dokument – 2<br />
                                           05. Seria i numer dokumentu</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="PESEL" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD><FONT size="2">
				            <TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					            <TR>
						            <TD width="10%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                                        <ea:DataLabel id="RODZAJ" runat="server"></ea:DataLabel>
                                    </TD>
						            <TD width="2%"></TD>
						            <TD width="88%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
							            <ea:DataLabel id="DOKUMENT" runat="server"></ea:DataLabel>
                                    </TD>
                                </TR>
                            </TABLE>
                        </FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD valign="bottom"><FONT size="2">06. Nazwa skrócona</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="NAZWASK" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD valign="bottom"><FONT size="2">07. Nazwisko</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="NAZWISKO" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD valign="bottom"><FONT size="2">08. Imię</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="IMIE" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
				</TABLE>
                <span style="font-size: 9pt">
                    (1) Należy wpisać numery NIP i REGON, a jeżeli nie nadano tych numerów albo jednego z nich, należy wpisać numer PESEL lub serię i numer dowodu osobistego albo innego dokumentu potwierdzającego tożsamość.
                </span>
			</P>
			<P>
                <b>DANE ADRESOWE PŁATNIKA SKŁADEK - ADRES SIEDZIBY</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">01. Kod pocztowy</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">02. Poczta</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="KODP" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="POCZTA" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD><FONT size="2">03. Gmina/Dzielnica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="GMINA" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">04. Miejscowość</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="MIEJSCOWOSC" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">05. Ulica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="ULICA" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="25%"><FONT size="2">06. Numer domu</FONT></TD>
						<TD width="1%"></TD>
						<TD width="22%"><FONT size="2">07. Numer lokalu</FONT></TD>
						<TD width="4%"></TD>
						<TD width="24%"><FONT size="2">08. Numer telefonu</FONT><FONT size="1"><span style="vertical-align: super">
                                (1)</span></FONT></TD>
						<TD width="1%"></TD>
						<TD width="23%"><FONT size="2">09. Symbol państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                (2) (3)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="DOM" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="LOKAL" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="TEL" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="SYMBOL" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">10. Zagraniczny kod pocztowy</FONT><FONT size="1"><span style="vertical-align: super">
                                (2)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">11. Nazwa państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                (2)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="KODZ" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="PANSTWO" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD width="48%"><FONT size="2">12. Adres poczty elektronicznej</FONT><FONT size="1"><span style="vertical-align: super">
                                (1)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel id="MAIL" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Podanie numeru telefonu i adresu poczty elektronicznej nie jest obowiązkowe.<br />
                    (2) Wypełnić w przypadku, gdy adres jest inny niż polski.<br />
                    (3) Podanie symbolu państwa nie jest konieczne, jeżeli wniosek jest zgłaszany w formie papierowej.<br />
                </span>
            </P>
			<P>
                <b>DANE IDENTYFIKACYJNE UBEZPIECZONEGO</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">01. Numer PESEL</FONT><FONT size="1"><span style="vertical-align: super">
                                (1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">02. Rodzaj dokumentu tożsamości: jeśli dowód osobisty, wpisać 1, jeśli inny dokument – 2<br />
                                                       03. Seria i numer dokumentu</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel DataMember="PracHistoria.PESEL" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD><FONT size="2">
				            <TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					            <TR>
						            <TD width="10%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                                        <ea:DataLabel id="DOKRODZAJ" runat="server"></ea:DataLabel>
                                    </TD>
						            <TD width="2%"></TD>
						            <TD width="88%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
							            <ea:DataLabel id="DOKUBEZP" runat="server"></ea:DataLabel>
                                    </TD>
                                </TR>
                            </TABLE>
                        </FONT></TD>
					</TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">04. Nazwisko</FONT></TD>
                    </TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel DataMember="PracHistoria.Nazwisko" runat="server"></ea:DataLabel></FONT></TD>
                    </TR>
					<TR>
						<TD width="48%" valign="bottom"><FONT size="2">05. Imię</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">06. Data urodzenia (dd/mm/rrrr)</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel DataMember="PracHistoria.Imie" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
							<ea:DataLabel id="URODZONY" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Należy wpisać numer PESEL, a jeżeli nie nadano tego numeru, należy wpisać serię i numer dowodu osobistego albo innego dokumentu potwierdzającego tożsamość.
                </span>
            </P>
            <br />
			<P>
                <b>DANE ADRESOWE UBEZPIECZONEGO - ADRES ZAMIESZKANIA</b>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">01. Kod pocztowy</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">02. Poczta</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresKodPocztowyS" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresPoczta" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD><FONT size="2">03. Gmina/Dzielnica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresGmina" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">04. Miejscowość</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
					<TR>
						<TD><FONT size="2">05. Ulica</FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="25%"><FONT size="2">06. Numer domu</FONT></TD>
						<TD width="1%"></TD>
						<TD width="22%"><FONT size="2">07. Numer lokalu</FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">08. Symbol państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                (1) (2)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresKodKraju" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
						<TD width="48%"><FONT size="2">09. Zagraniczny kod pocztowy</FONT><FONT size="1"><span style="vertical-align: super">
                                (1)</span></FONT></TD>
						<TD width="4%"></TD>
						<TD width="48%"><FONT size="2">10. Nazwa państwa</FONT><FONT size="1"><span style="vertical-align: super">
                                (1)</span></FONT></TD>
					</TR>
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresZagranicznyKodPocztowy" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
						<TD></TD>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid"><FONT size="2">
								<ea:DataLabel ID="AdresKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT></TD>
					</TR>
                </TABLE>
                <span style="font-size: 9pt">
                    (1) Wypełnić w przypadku, gdy adres jest inny niż polski.<br />
                    (2) Podanie symbolu państwa nie jest konieczne, jeżeli wniosek jest zgłaszany w formie papierowej.<br />
                </span>
			</P>
            <P>
                Ubezpieczony występuje o:&nbsp;<FONT size="1"><span style="vertical-align: super">(należy zaznaczyć właściwy kwadrat)</span></FONT>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
                        <TD>&nbsp;</TD>
                    </TR>
					<TR>
						<TD width="2%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="1%"></TD>
						<TD width="22%"><FONT size="2">zasiłek chorobowy</FONT></TD>
                        <TD width="2%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="1%"></TD>
						<TD width="22%"><FONT size="2">zasiłek opiekuńczy</FONT></TD>
                        <TD width="2%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="1%"></TD>
						<TD width="22%"><FONT size="2">zasiłek macierzyński</FONT></TD>
                        <TD width="2%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="1%"></TD>
						<TD width="22%"><FONT size="2">świadczenie rehabilitacyjne</FONT></TD>
                    </TR>
					<TR>
                        <TD>&nbsp;</TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="100%" border="0">
					<TR>
                        <TD width="12%"><FONT size="2">za okres od:&nbsp;</FONT></TD>
						<TD width="19%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="2%"></TD>
                        <TD width="3%"><FONT size="2">do:&nbsp;</FONT></TD>
						<TD width="19%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="2%"></TD>
                        <TD width="22%"><FONT size="2">seria i numer zaśw. lek.</FONT><FONT size="1"><span style="vertical-align: super">
                                (2)</span>&nbsp;</FONT></TD>
						<TD width="25%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                    </TR>
					<TR>
                        <TD>&nbsp;</TD>
                    </TR>
					<TR>
                        <TD width="10%"><FONT size="2">za okres od:&nbsp;</FONT></TD>
						<TD width="19%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="2%"></TD>
                        <TD width="3%"><FONT size="2">do:&nbsp;</FONT></TD>
						<TD width="19%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="2%"></TD>
                        <TD width="20%"><FONT size="2">seria i numer zaśw. lek.</FONT><FONT size="1"><span style="vertical-align: super">
                                (2)</span>&nbsp;</FONT></TD>
						<TD width="25%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                    </TR>
					<TR>
                        <TD>&nbsp;</TD>
                    </TR>
					<TR>
                        <TD width="10%"><FONT size="2">za okres od:&nbsp;</FONT></TD>
						<TD width="19%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="2%"></TD>
                        <TD width="3%"><FONT size="2">do:&nbsp;</FONT></TD>
						<TD width="19%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                        <TD width="2%"></TD>
                        <TD width="20%"><FONT size="2">seria i numer zaśw. lek.</FONT><FONT size="1"><span style="vertical-align: super">
                                (2)</span>&nbsp;</FONT></TD>
						<TD width="25%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">&nbsp;</FONT></TD>
                    </TR>
                </TABLE>
            </P>
			<FONT face="Tahoma" size="2">
			<OL>
				<LI>
					Jest
					<ea:DataLabel id="DataLabel50" runat="server" Bold="False" DataMember="PracHistoria.Plec">
						<ValuesMap>
							<ea:ValuesPair Key="Kobieta" Value="objęta"></ea:ValuesPair>
							<ea:ValuesPair Key="Mężczyzna" Value="objęty"></ea:ValuesPair>
						</ValuesMap>
					</ea:DataLabel>:<br/>
					- ubezpieczeniem w razie choroby i macierzyństwa (ubezpieczenie chorobowe):
                    <ea:DataLabel id="UbezpChor" runat="server" Bold="false"></ea:DataLabel>
                    <br />
					- ubezpieczeniem z tytułu wypadków przy pracy i chorób zawodowych (ubezpieczenie wypadkowe):
                    <ea:DataLabel id="UbezpWyp" runat="server" Bold="false"></ea:DataLabel>
                    <br />
					jako:<br/>
					<OL>
						<LI>
                        osoba wykonująca pozarolniczą działalność,
						<LI>
                        osoba współpracująca z osobą prowadzącą pozarolniczą działalność,
						<LI>
                        duchowny.
					</OL>
					<br/>
			</OL>	
			</FONT>
			<FONT face="Tahoma" size="2">
			<OL>
				<LI value="2">
					Niezdolność do pracy powstała z powodu choroby zawodowej / wypadku przy pracy / wypadku
					w drodze do pracy lub z pracy<br/>
					Dokumentem potwierdzającym jest decyzja / karta wypadku<br />
					nr . . . . . . . . . . . . . . . . . . . z dnia . . . . . . . . . . . . . . . . . . .<br/>
					<br/>
			</OL>	
            <p>
				Numer rachunku bankowego ubezpieczonego
                <span style="vertical-align: super"><FONT size="1">(3)</FONT></span>:
				<TABLE id="Table4" cellSpacing="0" cellPadding="0" width="92%" border="0" style="font-size: 10pt; font-family: tahoma">
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        	<ea:DataLabel id="RachunekBank" runat="server"></ea:DataLabel>
						</TD>
					</TR>
                </TABLE>
            </p>
			</FONT>
		    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False">
		    <Subtitles>
			    <cc1:FooterSubtitle Caption="(Miejscowość)" Width="33"></cc1:FooterSubtitle>
			    <cc1:FooterSubtitle Caption="(Data: dd/mm/rrrr)" Width="33"></cc1:FooterSubtitle>
			    <cc1:FooterSubtitle Caption="(Podpis i pieczątka osoby upoważnionej [4])" Width="33"></cc1:FooterSubtitle>
		    </Subtitles>
		    </cc1:reportfooter>
			<ea:PageBreak id="PageBreak6" runat="server" Required="True"></ea:PageBreak></P>
            <p align="right">
                <b>ZUS Z-3b</b>
            </p>
			<FONT face="Tahoma" size="2">
			<P style="text-align: center"><FONT size="3"><b>POUCZENIE</b></FONT></P>
            <p style="text-align: justify">
				<b>Podstawa prawna: ustawa z dnia 25 czerwca 1999 r. o świadczeniach pieniężnych z ubezpieczenia społecznego w razie choroby i macierzyństwa
				(Dz.U. z 2014 r. poz. 159 ze zm.) oraz ustawa z dnia 30 października 2002 r. o ubezpieczeniu społecznym
				z tytułu wypadków przy pracy i chorób zawodowych (Dz. U. z 2015 r. poz. 1242, ze zm.).</b><br/>
			</p>
            <p style="text-align: justify">
                Osoby podlegające ubezpieczeniu chorobowemu z tytułu:<br/>
                1) wykonywania pozarolniczej działalności,<br/>
                2) współpracy z osobami prowadzącymi pozarolniczą działalność,<br/>
                3) bycia duchownym<br/>
                nabywają prawo do zasiłku chorobowego z ubezpieczenia chorobowego po upływie 90 dni nieprzerwanego ubezpieczenia chorobowego.<br/>
			</p>
            <p style="text-align: justify">
                Do 90-dniowego okresu ubezpieczenia chorobowego wlicza się poprzednie okresy ubezpieczenia chorobowego,
                jeżeli przerwa między nimi nie przekroczyła 30 dni lub była spowodowana urlopem bezpłatnym, urlopem wychowawczym
                albo odbywaniem czynnej służby wojskowej przez żołnierza niezawodowego. Do okresu ubezpieczenia
                chorobowego wlicza się również okresy ubezpieczenia społecznego przed dniem 1 stycznia 1999 r. Warunek posiadania
                okresu ubezpieczenia chorobowego nie obowiązuje:<br/>
                — absolwentów szkół oraz szkół wyższych, którzy zostali objęci ubezpieczeniem chorobowym w ciągu 90 dni
                od dnia ukończenia szkoły lub uzyskania dyplomu ukończenia studiów wyższych,<br/>
                — osób, których niezdolność do pracy została spowodowana chorobą zawodową, wypadkiem przy pracy,
                wypadkiem w drodze do pracy lub z pracy,<br/>
                — posłów i senatorów, którzy przystąpili do ubezpieczenia chorobowego w ciągu 90 dni od ukończenia
                kadencji.<br/>
			</p>
            <p style="text-align: justify">
                Okoliczności wyłączające obowiązek posiadania 90-dniowego okresu ubezpieczenia chorobowego należy udokumentować.<br/>
            </p>
            <p style="text-align: justify">
                Wypłaty świadczeń z tytułu wypadku przy pracy albo wypadku w drodze do pracy lub z pracy ZUS dokonuje
                po uprzednim uznaniu zdarzenia za taki wypadek, dlatego też należy dołączyć niezbędne dokumenty.
                W przypadku choroby zawodowej należy dołączyć decyzję o stwierdzeniu choroby zawodowej i zaświadczenie
                lekarza stwierdzające, że niezdolność do pracy jest spowodowana chorobą zawodową.<br/>
            </p>
            <p style="text-align: justify">
                Zaświadczenia płatnika składek nie składa się w przypadku kolejnego zaświadczenia lekarskiego za okres nieprzerwanej niezdolności do pracy.<br/>
            </p>
            <p style="text-align: justify">
                <b>Płatnik składek jest zobowiązany poinformować terenową jednostkę organizacyjną ZUS o okolicznościach mających wpływ na prawo
                i wysokość zasiłku, które uległy zmianie w stosunku do podanych w zaświadczeniu płatnika składek.</b><br/>
            </p>
            <p>
                <span style="font-size: 9pt">
                    [1] Pieczątka jest wymagana, jeżeli płatnik składek ją posiada, na dokumencie w formie papierowej.<br />
                    [2] Wypełnić w przypadku zasiłku chorobowego albo zasiłku opiekuńczego z tytułu opieki nad chorym dzieckiem lub innym chorym członkiem rodziny.<br />
                    [3] Podać w przypadku, gdy ubezpieczony wyraził wolę otrzymywania zasiłku na rachunek bankowy.<br />
                    [4] Pieczątka jest wymagana na dokumencie w formie papierowej.<br />
                </span>
            </p>
		    </FONT>
		</form>
	</body>
</HTML>
